/*
 * Decompiled with CFR 0.152.
 */
package uk.org.xlevel.Encoder;

import uk.org.xlevel.Encoder.Encoder;
import uk.org.xlevel.Encoder.EncodingException;

public class EncoderBase64
extends Encoder {
    private static final char[] BASE_64_CHARACTER_LIST = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
    private byte[] bCRLF = new byte[]{13, 10};
    private String CRLF = new String(this.bCRLF);

    public EncoderBase64() {
    }

    public EncoderBase64(byte[] p_data) {
        super(p_data);
    }

    public EncoderBase64(String p_data) {
        super(p_data);
    }

    public int getEncodeLength() {
        return (this.i_data.length + 2) / 3 * 4;
    }

    public String encode() throws EncodingException {
        int cnt = 0;
        int dataLength = this.i_data.length;
        int encodedLength = this.getEncodeLength();
        char[] encodedData = new char[encodedLength];
        StringBuffer outString = new StringBuffer();
        boolean quad = false;
        boolean trip = false;
        int i = 0;
        while (i < dataLength) {
            int val = 0xFF & this.i_data[i];
            val <<= 8;
            if (i + 1 < dataLength) {
                val |= 0xFF & this.i_data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < dataLength) {
                val |= 0xFF & this.i_data[i + 2];
                quad = true;
            }
            encodedData[cnt + 3] = BASE_64_CHARACTER_LIST[quad ? val & 0x3F : 64];
            encodedData[cnt + 2] = BASE_64_CHARACTER_LIST[trip ? (val >>= 6) & 0x3F : 64];
            encodedData[cnt + 1] = BASE_64_CHARACTER_LIST[(val >>= 6) & 0x3F];
            encodedData[cnt + 0] = BASE_64_CHARACTER_LIST[(val >>= 6) & 0x3F];
            i += 3;
            cnt += 4;
        }
        for (i = 0; i < encodedLength; ++i) {
            outString.append(encodedData[i]);
            if (i % 76 != 0 || i <= 0) continue;
            outString.append(this.CRLF);
        }
        return outString.toString();
    }

    public int getDecodeLength() {
        return this.i_data.length;
    }

    public String decode() throws EncodingException {
        return "";
    }
}

